---
title: Build caching · Cloudflare Workers docs
description: Improve build times by caching build outputs and dependencies
lastUpdated: 2025-06-05T13:25:05.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/ci-cd/builds/build-caching/
  md: https://developers.cloudflare.com/workers/ci-cd/builds/build-caching/index.md
---

Improve Workers build times by caching dependencies and build output between builds with a project-wide shared cache.

The first build to occur after enabling build caching on your Workers project will save relevant artifacts to cache. Every subsequent build will restore from cache unless configured otherwise.

## About build cache

When enabled, build caching will automatically detect which package manager and framework the project is using from its `package.json` and cache data accordingly for the build.

The following shows which package managers and frameworks are supported for dependency and build output caching respectively.

### Package managers

Workers build cache will cache the global cache directories of the following package managers:

| Package Manager | Directories cached |
| - | - |
| [npm](https://www.npmjs.com/) | `.npm` |
| [yarn](https://yarnpkg.com/) | `.cache/yarn` |
| [pnpm](https://pnpm.io/) | `.pnpm-store` |
| [bun](https://bun.sh/) | `.bun/install/cache` |

### Frameworks

Some frameworks provide a cache directory that is typically populated by the framework with intermediate build outputs or dependencies during build time. Workers Builds will automatically detect the framework you are using and cache this directory for reuse in subsequent builds.

The following frameworks support build output caching:

| Framework | Directories cached |
| - | - |
| Astro | `node_modules/.astro` |
| Docusaurus | `node_modules/.cache`, `.docusaurus`, `build` |
| Eleventy | `.cache` |
| Gatsby | `.cache`, `public` |
| Next.js | `.next/cache` |
| Nuxt | `node_modules/.cache/nuxt` |

Note

[Static assets](https://developers.cloudflare.com/workers/static-assets/) and [frameworks](https://developers.cloudflare.com/workers/framework-guides/) are now supported in Cloudflare Workers.

### Limits

The following limits are imposed for build caching:

* **Retention**: Cache is purged 7 days after its last read date. Unread cache artifacts are purged 7 days after creation.
* **Storage**: Every project is allocated 10 GB. If the project cache exceeds this limit, the project will automatically start deleting artifacts that were read least recently.

## Enable build cache

To enable build caching:

1. Navigate to [Workers & Pages Overview](https://dash.cloudflare.com) on the Dashboard.
2. Find your Workers project.
3. Go to **Settings** > **Build** > **Build cache**.
4. Select **Enable** to turn on build caching.

## Clear build cache

The build cache can be cleared for a project when needed, such as when debugging build issues. To clear the build cache:

1. Navigate to [Workers & Pages Overview](https://dash.cloudflare.com) on the Dashboard.
2. Find your Workers project.
3. Go to **Settings** > **Build** > **Build cache**.
4. Select **Clear Cache** to clear the build cache.
