---
title: Error 413 · Cloudflare Support docs
description: The 413 Payload Too Large status code indicates that the server
  refuses to process the request because the payload sent by the client exceeds
  the server's acceptable size limit. The server may optionally close the
  connection. If this refusal would only happen temporarily, then the server
  should send a Retry-After header to specify when the client should try the
  request again.
lastUpdated: 2025-05-30T09:29:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-413/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-413/index.md
---

## 413 Payload Too Large

The `413 Payload Too Large` status code indicates that the server refuses to process the request because the payload sent by the client exceeds the server's acceptable size limit. The server may optionally close the connection. If this refusal would only happen temporarily, then the server should send a `Retry-After` header to specify when the client should try the request again.

For more details, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

The `413 Payload Too Large` status code often occurs when clients attempt to upload large files, such as videos or images, or send oversized request bodies, like JSON or XML payloads, that exceed the server's size limits. This can also happen during file transfers or API requests involving large datasets, prompting the server to reject the request.

### Cloudflare-specific information

The upload limit for the Cloudflare API depends on your plan. If you exceed this limit, your API call will receive a `413 Request Entity Too Large` error.

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Max upload size | 100 MB | 100 MB | 200 MB | 500+ MB |

Keep in mind, customers can reduce the **Maximum Upload Size** from the zone's **Network** page which can cause a `413`.

If you require a larger upload, break up requests into smaller chunks, change your DNS record to [DNS-only](https://developers.cloudflare.com/dns/proxy-status/#dns-only-records), or [upgrade your plan](https://developers.cloudflare.com/billing/change-plan/).
